/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Design;
using System.Reflection;

using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Handles;

namespace Borland.Eco.Web
{
	///<summary>
	///Enum for available actions.
	///</summary>
	public enum ListAction
	{
		///<summary>No action will be performed.</summary>
		None,
		///<summary>A new object of the handles type will be created.</summary>
		AddNew
	}

	///<summary>
	///<para>EcoAspListActionExtender extends ASP-buttons with a new property EcoListAction.</para>
	///<para>This allows code free execution of common things to do in an ecospace. currently only AddNew.</para>
	///</summary>
	[ProvideProperty("EcoListAction", typeof(System.Web.UI.Control))]
	[ProvideProperty("RootHandle", typeof(System.Web.UI.Control))]
	[ToolboxBitmap(typeof(EcoAspListActionExtender), "Borland.Eco.Web.EcoAspListActionExtender.bmp")]
	[ToolboxItemFilter("System.Web.UI")]
	public class EcoAspListActionExtender: System.ComponentModel.Component, System.ComponentModel.IExtenderProvider
	{
		private readonly Hashtable m_Actions = new Hashtable();
		private readonly Hashtable m_RootHandles = new Hashtable();

	///<summary>
	///<para>Constructor. Creates an instance of the class.</para>
	///</summary>
		public EcoAspListActionExtender()
		{
		}

		#region IExtenderProvider implementation
		/// <summary>
		/// Defines which components will be extended.
		/// Currently only extend buttons
		/// </summary>
		bool IExtenderProvider.CanExtend(object extendee)
		{
			return (extendee is System.Web.UI.WebControls.Button);
		}
		#endregion

		#region EcoListAction
		///<summary>
		///Getter for EcoListAction
		///</summary>
//		[LocalizableCategory("sCategoryEcoListAction")]
//		[LocalizableDescription("sPropertyEcoListAction")]
		[DefaultValue(ListAction.None)]
		public ListAction GetEcoListAction(System.Web.UI.Control control)
		{
			if (m_Actions[control] == null)
				return ListAction.None;
			else
				return (ListAction)m_Actions[control];
		}

		/// <summary>
		/// Sets the EcoListAction on the extendee. Also sets caption - if caption has not been changed from a default value
		/// and hooks up/removed ImageList and ImageIndex on extendee.
		/// </summary>
		public void SetEcoListAction(System.Web.UI.Control control, ListAction value)
		{
			System.Web.UI.WebControls.Button button = (System.Web.UI.WebControls.Button)control;
			if (value == ListAction.None)
			{
				m_Actions.Remove(control);

				button.Click -= new EventHandler(OnClick);
			}
			else
			{
				m_Actions[control] = value;
				button.Click += new EventHandler(OnClick);
			}
		}
		#endregion

		#region RootHandle
		///<summary>
		///Getter for RootHandle
		///</summary>
//		[LocalizableCategory("sCategoryEcoListAction")]
//		[LocalizableDescription("sPropertyRootHandle")]
		[DefaultValue(null)]
		[Editor("Borland.Eco.Handles.Design.RootHandleEditor, Borland.Eco.Handles.Design", typeof(UITypeEditor))]
		public ElementHandle GetRootHandle(System.Web.UI.Control control)
		{
			return m_RootHandles[control] as ElementHandle;
		}
		///<summary>
		///Setter for RootHandle
		///</summary>
		public void SetRootHandle(System.Web.UI.Control control, ElementHandle value)
		{
			if (value == null)
				m_RootHandles.Remove(control);
			else
				m_RootHandles[control] = value;
		}
		#endregion

		private void OnClick(object sender, EventArgs e)
		{
			System.Web.UI.Control control = sender as System.Web.UI.Control;
			ElementHandle handle = GetRootHandle(control);
			IElementCollection ec = handle.Element.GetAsCollection();
			if (ec.SupportsAddNew)
				ec.AddNew();
			control.Page.DataBind();
		}
	}
}
